package gov.va.med.mhv.sm.web.reports;

import gov.va.med.mhv.sm.enumeration.CountsSubCategoryEnum;
import gov.va.med.mhv.sm.enumeration.ReportingCountsTypeEnum;
import gov.va.med.mhv.sm.model.report.CountsResults;
import gov.va.med.mhv.sm.model.report.CountsResultsDetails;

import java.util.Date;
import java.util.Map;

import org.jfree.data.category.DefaultIntervalCategoryDataset;

import de.laures.cewolf.DatasetProducer;

public class GraphBarDatasetProducer implements DatasetProducer {
	private static final long serialVersionUID = -2701489958239252211L;

	CountsResultsDetails d;

	CountsResults c;

	int subCategoryFilter;

	ReportingCountsTypeEnum type = ReportingCountsTypeEnum.COUNTS;

	public void setCountsResultsDetails(CountsResults c,
			CountsResultsDetails d, int subCategoryFilter,
			ReportingCountsTypeEnum type) {
		this.c = c;
		this.d = d;
		this.subCategoryFilter = subCategoryFilter;
		this.type = type;
	}

	// seriesName is subcategory

	private String[] getSeriesNames() {
		if (subCategoryFilter != -1) {
			// Subfilter active
			return new String[] { CountsSubCategoryEnum.valueOf(
					subCategoryFilter).getDescription() };
		}

		return c.getSubCategoriesAsStringsForType(type)
				.toArray(new String[] {});
	}

	public Object produceDataset(Map params) {
		String[] seriesNames = getSeriesNames();
		String[] categories = c.getFormattedPeriods().toArray(new String[] {});

		Double[][] startValues = new Double[seriesNames.length][categories.length];
		Double[][] endValues = new Double[seriesNames.length][categories.length];
		Double zero = new Double(0);

		for (int series = 0; series < seriesNames.length; series++) {
			for (int i = 0; i < categories.length; i++) {
				String val = null;
				if (subCategoryFilter != -1) {
					val = d.getValue(i, c.getSubCategoryPosition(
							subCategoryFilter).intValue());
				} else {
					val = d.getValue(i, series);
				}
				Double valInt = zero;
				if (val != null && val.length() != 0)
					valInt = Double.valueOf(val);
				startValues[series][i] = zero;
				endValues[series][i] = valInt;
			}
		}

		DefaultIntervalCategoryDataset ds = new DefaultIntervalCategoryDataset(
				seriesNames, categories, startValues, endValues);
		return ds;
	}

	public String getProducerId() {
		return "CategoryDataProducer";
	}

	public boolean hasExpired(Map params, Date since) {
		return true;
	}
}
